/*!
*******************************************************************************
* \file             mspinAudioStream.h
* \brief            Implements the Audio functionality for mySPIN
*******************************************************************************
\verbatim
PROJECT:        Gen3 Projects
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Audio Streaming (Lib) Implementation for mySPIN using gstreamer
COPYRIGHT:      &copy; BSOT

HISTORY:
Date       |  Author                          | Modifications
19.02.2016 |  J. Schmidt                      | initial version

\endverbatim
******************************************************************************/

#ifndef __MYSPINAUDIOSTREAM_H__
#define __MYSPINAUDIOSTREAM_H__

#include <string>
#include <adit-system/adit_typedef.h>

#include <functional>
using namespace std::placeholders;        // for `_1`, `_2`

typedef enum {
   AUDIO_DEVICE_TYPE_BT,                // BT-Audio
   AUDIO_DEVICE_TYPE_ALSA,              // i.e. iPhone
   AUDIO_DEVICE_TYPE_ALSA_W_SNDCTL      // i.e. iPhone with active sample rate adaption
}audioStreamDeviceType;

typedef enum {
   AUDIO_STREAM_MESSAGE_WARNING,
   AUDIO_STREAM_MESSAGE_ERROR
   // TBD: Expand
}audioStreamError;

typedef struct {
   std::string codecName;           // name of stream codec
   U32 sampleRate;                  // sample rate
   U8 channels;                     // audio channels
   U8 sampleWidth;                  // sample width in bit
   U8 sampleDepth;                  // sample depth in bit
   bool sampleSignedness;           // sample signedness
   bool sampleEndianness;           // sample endianness
}audioStreamConfig;


typedef std::function<void(U32, audioStreamError, std::string)> vOnAudioStreamError;
typedef std::function<void(U32, U32)> vOnAudioStreamRateChange;

struct audioStreamCallbacks
{
   vOnAudioStreamError fvOnAudioStreamError;
   vOnAudioStreamRateChange fvOnAudioStreamRateChange;

   audioStreamCallbacks() :
      fvOnAudioStreamError(NULL),
      fvOnAudioStreamRateChange(NULL)
   {
   }
};

class spi_tclMySpinAudioStream;

class MySpinAudioStream
{

public:
    MySpinAudioStream();

    virtual ~MySpinAudioStream();

    virtual S32 setAudioStreamConfig(const audioStreamConfig audStreamConfig);
    virtual S32 setAudioStreamInputDevice( std::string inDeviceName, audioStreamDeviceType audStreamDeviceType );
    virtual S32 setAudioStreamOutputDevice( std::string outDeviceName );

    virtual S32 startAudioStream();
    virtual S32 stopAudioStream();

    virtual void registerCallbacks(U32 context, audioStreamCallbacks audioCallbacks);

private:

    spi_tclMySpinAudioStream* m_poMySpinAudioStream;
};


#endif /* __MYSPINAUDIOSTREAM_H__ */
